#!/bin/bash

# rundf.sh
#
# Usage: rundf.sh <temp file> <log file>
#
# Return Codes:
# 1 - Error running df command
#
# Author: C. Schuck
# 05/20/2003  P. Provost  changed 2>&1 to > /dev/null

TEMPFILE=$1
LOGFILE=$2

echo "-> rundf.sh" >> $LOGFILE
echo "Running df command to check the filesystems of media for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> rundf.sh"
actzTrace "XMDA   F: rundf.sh: Running df command to check the filesystems of media for `date`"

if ! df --print-type | tee --append $TEMPFILE $LOGFILE > /dev/null; then
   echo "Couldn't run df.. exiting" >> $LOGFILE
   actzTrace "XMDA   F: rundf.sh: Couldn't run df.. exiting"
   exit 1
fi

actzTrace "XMDA   T: <- rundf.sh"
echo "<- rundf.sh" >> $LOGFILE
echo "" >> $LOGFILE

exit 0

